package com.orangemarshall.hudproperty.screen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import com.orangemarshall.hudproperty.base.IAdvancedRenderer;
import com.orangemarshall.hudproperty.util.ScreenPosition;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;

public class AdvancedPropertyScreen extends GuiScreen {
	private final HashMap<IAdvancedRenderer,ScreenPosition> renderers = new HashMap<>();
	private List<Entry<IAdvancedRenderer,ScreenPosition>> selectedRenderers = new ArrayList<>();
	private Minecraft mc;
	private boolean renderWhiteOverlay;

	private int prevX, prevY;

	public AdvancedPropertyScreen(IAdvancedRenderer[] renderer){
		this.mc = Minecraft.getMinecraft();
		for(IAdvancedRenderer ren : renderer){ // Load all entries
			ScreenPosition pos;
			if((pos = ren.load()) == null){
				pos = ScreenPosition.newAbsolute(5, 5);
			}
			renderers.put(ren, pos);
			checkBounds(ren, pos);	// Don't be outside of screen
		}
		mc.displayGuiScreen(this);
	}

	@Override
	public void drawScreen(int x, int y, float partialTicks) {
		super.drawDefaultBackground();

		float zBackup = this.zLevel;
		
		this.zLevel = 200;	
		renderers.entrySet().forEach((entry) -> { // Render all entries
			entry.getKey().render(entry.getValue());
			this.zLevel++;
		});

		super.drawScreen(x, y, partialTicks);

		this.zLevel = zBackup;
	}

	@Override
	protected void keyTyped(char c, int key) {
		if (key == 1) {
			renderers.entrySet().forEach((entry) -> { // Save all entries
				entry.getKey().save(entry.getValue());	
			});
			this.mc.displayGuiScreen(null);
		}
	}

	@Override
	protected void mouseClicked(int x, int y, int button) throws IOException {
		prevX = x;
		prevY = y;
		loadMouseOver(x, y);
		
		super.mouseClicked(x, y, button);
	}

	@Override
	protected void mouseClickMove(int x, int y, int button, long time) {
		selectedRenderers.forEach((entry) -> { // Move selected entrie(s)
			ScreenPosition position = entry.getValue();
			position.setAbsolute(position.getAbsoluteX() + x - prevX, y - prevY + position.getAbsoluteY());
			checkBounds(entry.getKey(), position);
		});

		this.prevX = x;
		this.prevY = y;
		super.mouseClickMove(x, y, button, time);
	}

	@Override
	public void onGuiClosed() {
		renderers.entrySet().forEach((entry) -> {
			entry.getKey().save(entry.getValue());
		});
	}

	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}

	private void checkBounds(IAdvancedRenderer renderer, ScreenPosition pos){
		ScaledResolution res = new ScaledResolution(mc);
		int screenWidth = res.getScaledWidth();
		int screenHeight = res.getScaledHeight();
		pos.setAbsolute(Math.max(0, Math.min(pos.getAbsoluteX(), Math.max(screenWidth-renderer.getWidth(), 0))), Math.max(0, Math.min(pos.getAbsoluteY(), Math.max(screenHeight-renderer.getHeight(), 0))));
	}
	
	private void loadMouseOver(int x, int y){
		selectedRenderers.clear();
		Iterator<Entry<IAdvancedRenderer,ScreenPosition>> it = renderers.entrySet().iterator();
		while(it.hasNext()){
			Entry<IAdvancedRenderer,ScreenPosition> entry = it.next();
			IAdvancedRenderer renderer = entry.getKey();
			ScreenPosition pos = entry.getValue();
			int absoluteX = pos.getAbsoluteX();
			int absoluteY = pos.getAbsoluteY();
			if(x >= absoluteX && x <= absoluteX + renderer.getWidth()
					&& y >= absoluteY && y <= absoluteY + renderer.getHeight()){
				selectedRenderers.add(entry);
				break;
			}
		}
	}
}
